#include <bits/stdc++.h>
using namespace std;

using ll = long long;

const int mxN = 3010;
vector<int> adj[mxN];
vector<bool> visited(mxN, false);

void precomp() {
    for (int i = 0; i < mxN; i++) {
        visited[i] = false;
        adj[i].clear();
    }
}

pair<int, int> bfs(int u) {
    queue<pair<int, int>> q;
    q.push({u, 0});

    pair<int, int> maks = {u, 0};

    while(!q.empty()) {
        auto curr = q.front();
        q.pop();

        if (curr.second > maks.second) {
            maks = curr;
        }
        visited[curr.first] = true;

        for (int v : adj[curr.first]) {
            if(visited[v] == false) {
                q.push({v, curr.second + 1});
            }
        }
    }

    return maks;
}

void solve() {
    int n, k;
    cin >> n >> k;

    for (int i = 1; i <= n; i++) {
        adj[i].clear();
        visited[i] = false;
    }

    for (int i = 0; i < n - 1; i++) {
        int u, v; cin >> u >> v;
        adj[u].push_back(v);
        adj[v].push_back(u);
    }

    int start = bfs(1).first;
//    cout << "START: " << start << "\n";

    for (int i = 1; i <= n; i++) visited[i] = false;

    auto kraj = bfs(start);
 //   cout << "END: " << kraj.first << "\n";

    int diameter = kraj.second;
 //   cout << "DIJAMETER: " << diameter << "\n";

    int edges_left = n - 1 - diameter;
    cout << diameter + min(edges_left, k) << "\n";
}

int main()
{
    ios::sync_with_stdio(0);
    cin.tie(0);
    cout.tie(0);

    int t; cin >> t;
    while(t--) {
   //     precomp();
        solve();
    }
    return 0;
}